<?php
/**
 * ----------------------------------------------------
 * Role & Hak Akses Pengguna
 * Aplikasi Koperasi
 * ----------------------------------------------------
 */

// Daftar role sistem
define('ROLE_ADMIN', 'admin');
define('ROLE_PENGURUS', 'pengurus');
define('ROLE_KASIR', 'kasir');
define('ROLE_ANGGOTA', 'anggota');

// Cek apakah user punya role tertentu
function has_role($role)
{
    return isset($_SESSION['role']) && $_SESSION['role'] === $role;
}

// Cek apakah user termasuk salah satu role
function has_any_role(array $roles)
{
    return isset($_SESSION['role']) && in_array($_SESSION['role'], $roles);
}

// Redirect jika role tidak sesuai
function require_role($role)
{
    if (!has_role($role)) {
        header("HTTP/1.1 403 Forbidden");
        die("Akses ditolak.");
    }
}

// Redirect jika user bukan salah satu role
function require_any_role(array $roles)
{
    if (!has_any_role($roles)) {
        header("HTTP/1.1 403 Forbidden");
        die("Akses ditolak.");
    }
}
